/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
public final class AcsStartupUtil {
    private static List<AcsLaunchLogEvent> m_delayedLogEntries = new ArrayList<AcsLaunchLogEvent>();

    public static void addDelayedLog(Object object) {
        if (null != m_delayedLogEntries) {
            m_delayedLogEntries.add(object instanceof AcsLaunchLogEvent ? (AcsLaunchLogEvent)object : new AcsLaunchLogEvent(AcsStartupUtil.getCallerFrame(), Level.INFO, object));
        }
    }

    public static void addDelayedLog(Object object, StackTraceElement stackTraceElement) {
        if (null != m_delayedLogEntries) {
            m_delayedLogEntries.add(object instanceof AcsLaunchLogEvent ? (AcsLaunchLogEvent)object : new AcsLaunchLogEvent(stackTraceElement, Level.INFO, object));
        }
    }

    public static List<AcsLaunchLogEvent> getDelayedLogs() {
        return null == m_delayedLogEntries ? new ArrayList() : m_delayedLogEntries;
    }

    public static void invalidateDelayedLogBuffer() {
        m_delayedLogEntries = null;
    }

    protected static byte[] byteArrayFromByteBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
        byte[] byArray = new byte[byteBuffer2.capacity()];
        byteBuffer2.rewind();
        byteBuffer2.get(byArray);
        return byArray;
    }

    private static ByteBuffer readEntireZipEntryToBuffer(ZipInputStream zipInputStream, int n) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(zipInputStream);
        ReadableByteChannel readableByteChannel = Channels.newChannel(bufferedInputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        for (int i = 0; i < n; i += readableByteChannel.read(byteBuffer)) {
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    protected static ByteBuffer readEntireZipEntryToBuffer(ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
        int n;
        int n2 = (int)zipEntry.getSize();
        if (0 < n2) {
            return AcsStartupUtil.readEntireZipEntryToBuffer(zipInputStream, n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        byte[] byArray = new byte[524288];
        while (-1 != (n = zipInputStream.read(byArray, 0, byArray.length))) {
            n3 += n;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n3);
        byteBuffer.put(byteArrayOutputStream.toByteArray(), 0, n3);
        return byteBuffer;
    }

    protected static ByteBuffer readEntireNestedJarToBuffer(String string) throws IOException {
        int n;
        InputStream inputStream = AcsStartupUtil.class.getClassLoader().getResourceAsStream(string.replaceFirst("^/", ""));
        if (null == inputStream) {
            throw new FileNotFoundException(string);
        }
        int n2 = inputStream.available();
        int n3 = n2 > 0 ? n2 : 0x400000;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        int n4 = Math.min(0x100000, n3);
        byte[] byArray = new byte[n4];
        int n5 = 0;
        while (-1 != (n = inputStream.read(byArray, 0, byArray.length))) {
            n5 += n;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5);
        byteBuffer.put(byteArrayOutputStream.toByteArray(), 0, n5);
        return byteBuffer;
    }

    private AcsStartupUtil() {
    }

    public static InputStream getResourceStream(ClassLoader classLoader, String string, boolean bl) throws IOException {
        if (bl) {
            URLConnection uRLConnection;
            URL uRL = classLoader.getResource(string);
            if (null != uRL && null != (uRLConnection = uRL.openConnection())) {
                uRLConnection.setUseCaches(false);
                return uRLConnection.getInputStream();
            }
        } else {
            return classLoader.getResourceAsStream(string);
        }
        return null;
    }

    public static boolean blastFileRecursively(File file) {
        if (null == file || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            boolean bl = true;
            File[] fileArray = file.listFiles();
            if (null != fileArray) {
                for (File file2 : fileArray) {
                    bl = bl && AcsStartupUtil.blastFileRecursively(file2);
                }
            }
            return bl && file.delete();
        }
        return file.delete();
    }

    public static StackTraceElement getCallerFrame(int n) {
        Exception exception = new Exception();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        return 1 + n >= stackTraceElementArray.length ? stackTraceElementArray[stackTraceElementArray.length - 1] : stackTraceElementArray[1 + n];
    }

    public static StackTraceElement getCallerFrameThatsNotThisClass(String string) {
        Exception exception = new Exception();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 3; i < stackTraceElementArray.length; ++i) {
            if (stackTraceElementArray[i].getClassName().equals(string)) continue;
            return stackTraceElementArray[i];
        }
        return stackTraceElementArray[3];
    }

    public static StackTraceElement getCallerFrame() {
        return AcsStartupUtil.getCallerFrame(2);
    }

    @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
    public static class AcsLaunchLogEvent {
        private final StackTraceElement m_stackFrame;
        private final Object m_data;
        private final Level m_level;
        private final Date m_date;

        public AcsLaunchLogEvent(StackTraceElement stackTraceElement, Level level, Object object) {
            this.m_stackFrame = stackTraceElement;
            this.m_data = object;
            this.m_level = level;
            this.m_date = new Date();
        }

        public AcsLaunchLogEvent(AcsLaunchLogEvent acsLaunchLogEvent) {
            this.m_stackFrame = acsLaunchLogEvent.getStackFrame();
            this.m_data = acsLaunchLogEvent.getData();
            this.m_level = acsLaunchLogEvent.getLevel();
            this.m_date = acsLaunchLogEvent.getDate();
        }

        public StackTraceElement getStackFrame() {
            return this.m_stackFrame;
        }

        public Object getData() {
            return this.m_data;
        }

        public Date getDate() {
            return this.m_date;
        }

        public Level getLevel() {
            return this.m_level;
        }
    }

    @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
    public static class AcsPropertyUtf8Control
    extends ResourceBundle.Control {
        @Override
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IOException {
            AcsStartupUtil.addDelayedLog("new bundle requested, name=" + string + ", format=" + string2 + ", loader=" + classLoader + ", locale=" + locale);
            if ("java.properties".equals(string2)) {
                String string3 = this.toResourceName(this.toBundleName(string, locale), "properties");
                try (InputStream inputStream = AcsStartupUtil.getResourceStream(classLoader, string3, bl);){
                    if (inputStream != null) {
                        PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(inputStream, "UTF-8"));
                        return propertyResourceBundle;
                    }
                }
                return null;
            }
            if ("java.class".equals(string2)) {
                try {
                    Class<?> clazz = classLoader.loadClass(this.toBundleName(string, locale));
                    if (ResourceBundle.class.isAssignableFrom(clazz)) {
                        return (ResourceBundle)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    // empty catch block
                }
                return null;
            }
            throw new IllegalArgumentException(string2);
        }
    }

    @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
    static class mri {
        private static final String BUNDLE_NAME = "com.ibm.iaccess.launchmri.launch";
        private static final ResourceBundle RESOURCE_BUNDLE;

        private mri() {
        }

        protected static String nls(String string) {
            String string2 = '!' + string + '!';
            try {
                return null == RESOURCE_BUNDLE ? string2 : RESOURCE_BUNDLE.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return string2;
            }
        }

        static {
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault(), AcsStartupUtil.class.getClassLoader(), new AcsPropertyUtf8Control());
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
            }
            RESOURCE_BUNDLE = resourceBundle;
        }
    }
}

