/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.AcsBridge;
import com.ibm.iaccess.launch.AcsClassLoaderStatusEvent;
import com.ibm.iaccess.launch.AcsClassloader;
import com.ibm.iaccess.launch.AcsClassloaderStatusListener;
import com.ibm.iaccess.launch.AcsJarFileMgr;
import com.ibm.iaccess.launch.AcsLaunchLocator;
import com.ibm.iaccess.launch.AcsLookasideJarsMgr;
import com.ibm.iaccess.launch.AcsProperties;
import com.ibm.iaccess.launch.AcsStartupUtil;
import com.ibm.iaccess.launch.CopyrightLaunch;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
public class AcsLaunchPad {
    private static final String EMPTY_STR = "";
    private static final String NESTEDJARDEBUG = "com.ibm.iaccess.NestedJarDebug";
    public static final Locale LOCROOT = Locale.ROOT;
    private static final Color COLOR_DARK_BLUE = AcsLaunchPad.isGuiAvailable() ? new Color(0, 25, 110) : new Color(0, 25, 110);
    private static int m_splashWidth;
    private static int m_splashHeight;
    private static int m_textAreaXstart;
    private static int m_textAreaWidth;
    private static int m_textAreaYstart;
    private static int m_textAreaYstartClear;
    private static int m_textAreaHeight;
    private static int m_progressBarXstart;
    private static int m_progressBarXUpdate;
    private static int m_progressBarY;
    private static int m_progressBarChunks;
    private static int m_progressBarBumpSize;
    private static final SplashScreen m_splash;
    private static Graphics2D m_g2d;
    private static String m_previousMajorText;
    protected static AcsClassloaderStatusListener m_pleaseWaitDialog;
    private static String[] m_input_args;
    private static List<String> m_pluginsFound;
    private static boolean initializedForTesting;
    public static final String MANIFEST_PLUGINS = "Acs-Plugins";
    public static final String MANIFEST_CLASSPATH = "Class-Path";
    private static final String JARWITHCPMSG = "Adding jar with Class-Path";
    private static final String INNERJARWITHCPMSG = "Adding inner jar with Class-Path";
    private static final String JARFROMCPMSG = "Adding jar from Class-Path";
    private static final String INNERJARFROMCPMSG = "Adding inner jar from Class-Path";
    private static final String JARRESIDUALMSG = "Adding jar (residual)";
    private static final String INNERJARMSG = "Adding inner Jar";
    private static final String CHECK_PROD_MSG;
    private static final String[] m_base_lib_dirs_forURI;
    private static final String[] m_plugin_dirs;
    private static boolean g_optimizeForPlugin;
    private static final String[] OPTIMIZED_INTERNAL_PLUGINS;
    private static final String[] JARSWEKNOWDONTHAVEAMANIFEST;
    private static final String[] m_jarPrefixesMeaningNoManifest;
    private static final String[] m_jarFilesHiddenFromView;

    private AcsLaunchPad() {
    }

    public static boolean isGuiAvailable() {
        if (AcsLaunchPad.isIBMi()) {
            String string = System.getProperty("java.awt.headless");
            String string2 = System.getenv("DISPLAY");
            if ((null == string || string.equals("true")) && null == string2) {
                System.setProperty("java.awt.headless", "true");
                Beans.setGuiAvailable(false);
            }
        }
        boolean bl = Beans.isGuiAvailable();
        boolean bl2 = GraphicsEnvironment.isHeadless();
        return bl && !bl2;
    }

    private static boolean isIBMi() {
        String string = ManagementFactory.getOperatingSystemMXBean().getName().toLowerCase(Locale.US);
        return string.contains("os400") || string.contains("os/400");
    }

    public static void main(String[] stringArray) {
        boolean bl;
        String string2 = System.getProperty("java.version");
        boolean bl2 = bl = string2.startsWith("1.8") || string2.startsWith("11");
        if (bl) {
            AcsStartupUtil.addDelayedLog("Calling: System.setSecurityManager(null)");
            System.setSecurityManager(null);
        }
        System.setProperty("poi.delete.tmp.files.on.exit", "true");
        AcsProperties.getProperties();
        URL.setURLStreamHandlerFactory(string -> "acscl".equals(string) ? new AcsClassloader.ClassloaderURLHandler() : null);
        System.setProperty("com.ibm.iaccess", "true");
        AcsStartupUtil.addDelayedLog((Object)AcsProperties.getProperties());
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){
            public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n";

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                System.err.println("Detected error during initialization:");
                throwable.printStackTrace();
                AcsClassloader acsClassloader = AcsClassloader.getClassLoader();
                if (null != acsClassloader) {
                    acsClassloader.productSeemsStarted();
                }
                if (AcsLaunchPad.isGuiAvailable() && this == Thread.getDefaultUncaughtExceptionHandler()) {
                    String string = throwable.toString() + '\n';
                    for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                        string = string + "    " + stackTraceElement.toString() + '\n';
                    }
                    String string2 = string;
                    Runnable runnable = () -> JOptionPane.showMessageDialog(null, string2);
                    if (SwingUtilities.isEventDispatchThread()) {
                        runnable.run();
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(runnable);
                        }
                        catch (InterruptedException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                    }
                }
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
        Thread[] threadArray = new Thread[2 + Thread.activeCount()];
        Thread.enumerate(threadArray);
        for (Thread thread : threadArray) {
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler2;
            if (null == thread || null == (uncaughtExceptionHandler2 = thread.getUncaughtExceptionHandler())) continue;
            thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        }
        int n = 0;
        try {
            n = AcsLaunchPad.initialize(stringArray, false);
        }
        catch (Exception exception) {
            uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), exception);
            throw new RuntimeException(exception);
        }
        if (0 != n) {
            System.exit(n);
        }
    }

    public static synchronized void initAcsEnvironmentForTesting(String ... stringArray) {
        System.setProperty("com.ibm.iaccess", "true");
        if (!initializedForTesting) {
            AcsLaunchPad.initialize(null == stringArray ? new String[]{} : stringArray, true);
            initializedForTesting = true;
        }
    }

    private static synchronized int initialize(String[] stringArray, boolean bl) {
        m_input_args = stringArray;
        if (stringArray.length > 0) {
            block2: for (String string : OPTIMIZED_INTERNAL_PLUGINS) {
                for (String string2 : stringArray) {
                    if (("/plugin=" + (String)string).equalsIgnoreCase(string2)) {
                        g_optimizeForPlugin = true;
                        AcsStartupUtil.addDelayedLog("optimizing classloader initialization for internal plugin");
                        continue block2;
                    }
                    if (!string2.toLowerCase(Locale.US).startsWith("/plugin=")) continue;
                }
            }
        }
        ClassLoader classLoader = AcsLaunchPad.class.getClassLoader();
        AcsStartupUtil.addDelayedLog("AcsLaunchPad classloader " + classLoader.toString());
        AcsLaunchPad.initForSplashScreenUpdate();
        AcsClassloader acsClassloader = AcsLaunchPad.initializeClassLoader();
        AcsClassloader.setClassLoader(acsClassloader);
        if (null != System.getProperty("com.ibm.iaccess.context.dump")) {
            @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
            class ContextDumper
            extends Thread {
                public ContextDumper() {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    while (true) {
                        Thread[] threadArray = new Thread[500];
                        int n = Thread.enumerate(threadArray);
                        for (int i = 0; i < n; ++i) {
                            System.out.println("\tContext classloader for thread [" + threadArray[i] + "] = " + threadArray[i].getContextClassLoader());
                        }
                        try {
                            ContextDumper.sleep(10000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }
            new ContextDumper().start();
        }
        Class<?> clazz = null;
        int n = 0;
        try {
            clazz = Class.forName("com.ibm.iaccess.base.AcsEnvironment", true, acsClassloader);
            AcsBridge acsBridge = (AcsBridge)clazz.getEnumConstants()[0];
            Object[] objectArray = new Object[]{stringArray, m_pluginsFound};
            AcsStartupUtil.addDelayedLog("Number of plugins found =" + m_pluginsFound.size());
            StringBuilder stringBuilder = new StringBuilder(3000);
            for (String string : m_pluginsFound) {
                stringBuilder.append(string);
                stringBuilder.append(";");
            }
            AcsStartupUtil.addDelayedLog("Plugins found: " + stringBuilder.toString());
            n = acsBridge.run(objectArray, bl);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return n;
    }

    private static AcsClassloader initializeClassLoader() {
        Comparable<File> comparable;
        String string = AcsLaunchLocator.getLocator().getUrl().toString();
        AcsStartupUtil.addDelayedLog("AcsLaunchPad location: " + string);
        AcsStartupUtil.addDelayedLog("Excluded components:" + AcsProperties.getProperties().getExcludedComps());
        AcsLookasideJarsMgr acsLookasideJarsMgr = new AcsLookasideJarsMgr();
        if (AcsLaunchLocator.getLocator().isInsideJarOrZip()) {
            Object[] objectArray;
            Object object2;
            ArrayList<URL> arrayList;
            m_pluginsFound = new ArrayList<String>();
            boolean bl = AcsProperties.getProperties().isLocalJarCaching();
            ArrayList<URL> arrayList2 = arrayList = !bl || acsLookasideJarsMgr.isPrimeNeeded() ? AcsLaunchPad.getNestedJars() : new ArrayList<URL>();
            if (bl) {
                try {
                    acsLookasideJarsMgr.load(arrayList);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                acsLookasideJarsMgr.getPlugins(m_pluginsFound);
            }
            if (Boolean.getBoolean(NESTEDJARDEBUG)) {
                System.out.println("nested jars: ");
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    objectArray = (URL[])object2.next();
                    System.out.println("    " + objectArray);
                }
            }
            if (null != (object2 = System.getProperty("com.ibm.iaccess.plugins"))) {
                AcsStartupUtil.addDelayedLog("plugins system property found: '" + (String)object2 + "'");
                for (String string2 : ((String)object2).split(";")) {
                    AcsLaunchPad.processPlugins(string2, false);
                }
            }
            m_pleaseWaitDialog.classloaderStatus(new AcsClassLoaderStatusEvent(AcsStartupUtil.mri.nls("acsmsg.2"), EMPTY_STR));
            objectArray = new URL[]{};
            AcsClassloader acsClassloader = new AcsClassloader(acsLookasideJarsMgr, (URL[])objectArray, arrayList, AcsLaunchPad.class.getClassLoader(), m_pleaseWaitDialog);
            String[][] stringArrayArray = new String[][]{{AcsStartupUtil.mri.nls("acsmsg.3"), "com.ibm.as400.access.AS400"}, {AcsStartupUtil.mri.nls("acsmsg.4"), "com.ibm.as400.access.Trace"}, {AcsStartupUtil.mri.nls("acsmsg.5"), "com.ibm.iaccess.mri.reused.CwbMriKeys_cwbcomsg"}, {AcsStartupUtil.mri.nls("acsmsg.6"), "com.ibm.iaccess.base.AcsSystemConfig"}};
            if (!g_optimizeForPlugin) {
                for (String[] stringArray : stringArrayArray) {
                    m_pleaseWaitDialog.classloaderStatus(new AcsClassLoaderStatusEvent(AcsStartupUtil.mri.nls("acsmsg.7"), stringArray[0]));
                    AcsLaunchPad.initClass(acsClassloader, stringArray[1]);
                }
                for (String string2 : m_pluginsFound) {
                    m_pleaseWaitDialog.classloaderStatus(new AcsClassLoaderStatusEvent(AcsStartupUtil.mri.nls("acsmsg.8"), string2));
                    AcsLaunchPad.initClass(acsClassloader, string2);
                }
            }
            m_pleaseWaitDialog.classloaderStatus(new AcsClassLoaderStatusEvent(AcsStartupUtil.mri.nls("acsmsg.9"), EMPTY_STR));
            AcsJarFileMgr.saveJarCache();
            return acsClassloader;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        m_pluginsFound = new ArrayList<String>();
        try {
            for (String string4 : m_base_lib_dirs_forURI) {
                String string5 = string + string4;
                URI uRI = new URI(string5);
                comparable = new File(uRI);
                if (comparable.exists() && comparable.isDirectory() && comparable.canRead()) {
                    AcsLaunchPad.addJarFilesExploded(comparable, arrayList);
                    continue;
                }
                AcsStartupUtil.addDelayedLog(comparable.toString() + " does not exist.");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            AcsStartupUtil.addDelayedLog(uRISyntaxException);
        }
        if (!g_optimizeForPlugin) {
            for (String string5 : m_plugin_dirs) {
                try {
                    String string3 = string + "plugins" + "/" + string5 + "/";
                    comparable = new URI(string3);
                    File file = new File((URI)comparable);
                    if (file.exists() && file.isDirectory() && file.canRead()) {
                        AcsLaunchPad.addPluginJarFilesUncompressed(string3, file, arrayList);
                        continue;
                    }
                    AcsStartupUtil.addDelayedLog(file.toString() + " not accessible.");
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                    AcsStartupUtil.addDelayedLog(uRISyntaxException);
                }
            }
            String string6 = System.getProperty("com.ibm.iaccess.plugins");
            if (null != string6) {
                AcsStartupUtil.addDelayedLog("plugins system property found: '" + (String)string6 + "'");
                for (String string4 : string6.split(";")) {
                    AcsLaunchPad.processPlugins(string4, false);
                }
            }
        }
        Object[] objectArray = new URL[arrayList.size()];
        arrayList.toArray(objectArray);
        ArrayList<URL> arrayList3 = new ArrayList<URL>();
        AcsJarFileMgr.saveJarCache();
        m_pleaseWaitDialog.productSeemsStarted();
        if (Boolean.getBoolean(NESTEDJARDEBUG)) {
            System.out.println("effective classpath jars: ");
            for (URL uRL : arrayList3) {
                System.out.println("    " + uRL);
            }
        }
        return new AcsClassloader(acsLookasideJarsMgr, (URL[])objectArray, arrayList3, AcsLaunchPad.class.getClassLoader(), m_pleaseWaitDialog);
    }

    private static void initClass(ClassLoader classLoader, String string) {
        try {
            Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Boolean.getBoolean(NESTEDJARDEBUG)) {
                for (AcsStartupUtil.AcsLaunchLogEvent acsLaunchLogEvent : AcsStartupUtil.getDelayedLogs()) {
                    System.out.println(acsLaunchLogEvent.getData().toString());
                }
                AcsStartupUtil.getDelayedLogs().clear();
            }
            classNotFoundException.printStackTrace();
        }
    }

    private static void addJarFilesExploded(File file, List<URL> list) {
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            return;
        }
        for (File file2 : fileArray) {
            if (!file2.getAbsolutePath().endsWith(".jar")) continue;
            try {
                File file3 = file2.getCanonicalFile();
                URL uRL = file3.toURI().toURL();
                AcsStartupUtil.addDelayedLog("Adding jar : " + uRL.toString());
                list.add(uRL);
                try (JarFile jarFile = new JarFile(file3);){
                    Manifest manifest = jarFile.getManifest();
                    String string = manifest.getMainAttributes().getValue(MANIFEST_PLUGINS);
                    if (null == string) continue;
                    AcsLaunchPad.processPlugins(string, false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AcsStartupUtil.addDelayedLog(exception);
            }
        }
    }

    private static void addPluginJarFilesUncompressed(String string, File file, List<URL> list) {
        Serializable serializable;
        Object object;
        File file2;
        String string2;
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            return;
        }
        for (File file3 : fileArray) {
            string2 = file3.getAbsolutePath();
            if (!string2.toLowerCase(Locale.US).endsWith(".jar") || AcsLaunchPad.isJarFileHiddenFromView(string2)) continue;
            try {
                file2 = file3.getCanonicalFile();
                object = new JarFile(file2);
                serializable = null;
                try {
                    String[] stringArray;
                    String string3;
                    Manifest manifest = ((JarFile)object).getManifest();
                    if (null == manifest || manifest.getMainAttributes().getValue("Acs-Skip") != null || null == (string3 = manifest.getMainAttributes().getValue(MANIFEST_PLUGINS))) continue;
                    AcsLaunchPad.processPlugins(string3, false);
                    String string4 = manifest.getMainAttributes().getValue(MANIFEST_CLASSPATH);
                    if (null == string4) continue;
                    URL uRL = file2.toURI().toURL();
                    AcsLaunchPad.addWithDeepCompare(uRL, list, JARWITHCPMSG);
                    for (String string5 : stringArray = string4.split("\\s")) {
                        try {
                            String string6 = string + string5;
                            URI uRI = new URI(string6);
                            File file4 = new File(uRI);
                            file2 = file4.getCanonicalFile();
                            URL uRL2 = file2.toURI().toURL();
                            AcsLaunchPad.addWithDeepCompare(uRL2, list, JARFROMCPMSG);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            AcsStartupUtil.addDelayedLog(exception);
                        }
                    }
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (object != null) {
                        if (serializable != null) {
                            try {
                                ((ZipFile)object).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            ((ZipFile)object).close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AcsStartupUtil.addDelayedLog(exception);
            }
        }
        for (File file3 : fileArray) {
            string2 = file3.getAbsolutePath();
            if (!string2.toLowerCase(Locale.US).endsWith(".jar") || AcsLaunchPad.isJarFileHiddenFromView(string2)) continue;
            try {
                file2 = file3.getCanonicalFile();
                object = file2.toURI();
                serializable = ((URI)object).toURL();
                AcsLaunchPad.addWithDeepCompare((URL)serializable, list, JARRESIDUALMSG);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AcsStartupUtil.addDelayedLog(exception);
            }
        }
    }

    protected static List<URL> getNestedJars() {
        URL uRL = AcsLaunchLocator.getLocator().getUrl();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        AcsLaunchPad.setSplashUpdatesForRewritingCache();
        m_pleaseWaitDialog.classloaderStatus(new AcsClassLoaderStatusEvent(CHECK_PROD_MSG, EMPTY_STR));
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.addAll(AcsJarFileMgr.getManager().getNestedJarNames());
            Collections.sort(linkedList);
            Iterator object = linkedList.iterator();
            while (object.hasNext()) {
                Object object2;
                String string = (String)object.next();
                if (AcsLaunchPad.isJarFileHiddenFromView(string)) continue;
                m_pleaseWaitDialog.classloaderStatus(new AcsClassLoaderStatusEvent(CHECK_PROD_MSG, string));
                for (String string2 : m_base_lib_dirs_forURI) {
                    if (!string.toLowerCase(Locale.US).startsWith(string2) || !string.toLowerCase(Locale.US).endsWith(".jar")) continue;
                    String string3 = "jar:" + uRL + "!/" + string;
                    object2 = new URL(string3);
                    AcsLaunchPad.addWithDeepCompare((URL)object2, arrayList, INNERJARMSG);
                    AcsLaunchPad.processNestedJarsManifest((URL)object2, false, null, null);
                }
                if (g_optimizeForPlugin) continue;
                String[] stringArray = new String[m_plugin_dirs.length];
                for (int i = 0; i < m_plugin_dirs.length; ++i) {
                    stringArray[i] = "plugins/" + m_plugin_dirs[i] + "/";
                }
                for (String string3 : stringArray) {
                    if (!string.startsWith(string3) || !string.toLowerCase(Locale.US).endsWith(".jar")) continue;
                    object2 = "jar:" + uRL + "!/" + string;
                    URL uRL2 = new URL((String)object2);
                    arrayList2.add(uRL2);
                    String string4 = "jar:" + uRL + "!/" + string3;
                    AcsLaunchPad.processNestedJarsManifest(uRL2, true, string4, arrayList);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            AcsStartupUtil.addDelayedLog(exception);
        }
        for (URL uRL3 : arrayList2) {
            AcsLaunchPad.addWithDeepCompare(uRL3, arrayList, JARRESIDUALMSG);
        }
        return arrayList;
    }

    private static boolean shouldSkipNestedJarManifest(String string, URL uRL) {
        if (null == string) {
            return true;
        }
        if (!uRL.toString().matches(".*/plugins/[^/]+/[^/]+$") && !uRL.toString().matches(".*/lib/[^/]+$")) {
            return true;
        }
        for (String string2 : JARSWEKNOWDONTHAVEAMANIFEST) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        for (String string2 : m_jarPrefixesMeaningNoManifest) {
            if (!string.toLowerCase(Locale.US).startsWith(string2.toLowerCase(Locale.US))) continue;
            return true;
        }
        return false;
    }

    private static void processNestedJarsManifest(URL uRL, boolean bl, String string, List<URL> list) {
        block10: {
            String[] stringArray;
            int n;
            String string2;
            try {
                string2 = uRL.toString();
                n = string2.lastIndexOf(47);
                if (n > 0 && AcsLaunchPad.shouldSkipNestedJarManifest((String)(stringArray = string2.substring(n + 1)), uRL) && !AcsProperties.getProperties().isInMemoryJarCaching()) {
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                int n2;
                StringBuilder stringBuilder;
                int n3;
                string2 = AcsJarFileMgr.getManifestEntry(uRL);
                n = 0;
                if (string2.contains(MANIFEST_PLUGINS)) {
                    n = 1;
                    stringArray = string2.split("\\r?\\n");
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        if (!stringArray[n3].startsWith(MANIFEST_PLUGINS)) continue;
                        stringBuilder = new StringBuilder(stringArray[n3]);
                        for (n2 = n3 + 1; n2 < stringArray.length && !stringArray[n2].isEmpty() && stringArray[n2].substring(0, 1).equals(" "); ++n2) {
                            stringBuilder.append(stringArray[n2].substring(1));
                        }
                        AcsLaunchPad.processPlugins(stringBuilder.toString(), true);
                        break;
                    }
                }
                if (n == 0 || !bl || !string2.contains(MANIFEST_CLASSPATH)) break block10;
                stringArray = string2.split("\\r?\\n");
                AcsLaunchPad.addWithDeepCompare(uRL, list, INNERJARWITHCPMSG);
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    if (!stringArray[n3].startsWith(MANIFEST_CLASSPATH)) continue;
                    stringBuilder = new StringBuilder(stringArray[n3]);
                    for (n2 = n3 + 1; n2 < stringArray.length && !stringArray[n2].isEmpty() && stringArray[n2].substring(0, 1).equals(" "); ++n2) {
                        stringBuilder.append(stringArray[n2].substring(1));
                    }
                    AcsLaunchPad.processNestedJarsClassPath(stringBuilder.toString(), string, list);
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AcsStartupUtil.addDelayedLog(exception);
            }
        }
    }

    private static void processNestedJarsClassPath(String string, String string2, List<URL> list) {
        String[] stringArray = string.split("\\s");
        for (int i = 1; i < stringArray.length; ++i) {
            if (0 == stringArray[i].trim().length()) continue;
            String string3 = string2 + stringArray[i];
            try {
                URL uRL = new URL(string3);
                AcsLaunchPad.addWithDeepCompare(uRL, list, INNERJARFROMCPMSG);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AcsStartupUtil.addDelayedLog(exception);
            }
        }
    }

    private static void processPlugins(String string, boolean bl) {
        AcsLaunchPad.delayedLogIfNestedJarDebug("Processing plugins. Meta Entry='" + string + "' skipFirst? " + bl);
        String[] stringArray = string.split("\\s");
        int n = 0;
        if (bl) {
            n = 1;
        }
        while (n < stringArray.length) {
            if (0 != stringArray[n].length()) {
                AcsLaunchPad.delayedLogIfNestedJarDebug("Processing plugin '" + stringArray[n] + "'");
                if (-1 == m_pluginsFound.indexOf(stringArray[n])) {
                    m_pluginsFound.add(stringArray[n]);
                }
            }
            ++n;
        }
    }

    private static void addWithDeepCompare(URL uRL, List<URL> list, String string) {
        String string2 = uRL.toString();
        for (URL uRL2 : list) {
            String string3 = uRL2.toString();
            if (!string2.equals(string3)) continue;
            return;
        }
        list.add(uRL);
    }

    public static String[] getInputArgs() {
        return m_input_args;
    }

    private static void delayedLogIfNestedJarDebug(Object object) {
        if (Boolean.getBoolean(NESTEDJARDEBUG)) {
            AcsStartupUtil.addDelayedLog(object, AcsStartupUtil.getCallerFrame());
        }
    }

    protected static boolean isJarFileHiddenFromView(String string) {
        String string2 = string.toLowerCase(Locale.US).trim().replaceAll("\\\\", "/");
        AcsLaunchPad.delayedLogIfNestedJarDebug("Checking whether we should hide file " + string + "+(" + string2 + ")");
        if (!string2.matches(".*/plugins/.*/.*") && !string2.matches("^plugins/.*/.*")) {
            AcsLaunchPad.delayedLogIfNestedJarDebug("not a plugin. Cannot remove");
            return false;
        }
        String string3 = string2.replaceAll(".*/", EMPTY_STR).trim();
        String string4 = string2.replaceAll("/[^/]*$", EMPTY_STR).replaceAll(".*/", EMPTY_STR).trim();
        AcsLaunchPad.delayedLogIfNestedJarDebug(String.format("basename is '%s', dir is '%s'", string3, string4));
        if (Arrays.asList(m_jarFilesHiddenFromView).contains(string3.toLowerCase(Locale.US))) {
            return true;
        }
        for (String string5 : AcsProperties.getProperties().getExcludedComps()) {
            if (string5.equalsIgnoreCase(string4)) {
                AcsLaunchPad.delayedLogIfNestedJarDebug("---- hiding file " + string + " (plugin)");
                return true;
            }
            if (!"misc".equals(string4) || !string3.equalsIgnoreCase("acs" + string5 + ".jar")) continue;
            AcsLaunchPad.delayedLogIfNestedJarDebug("---- hiding file " + string + " (misc)");
            return true;
        }
        AcsLaunchPad.delayedLogIfNestedJarDebug("Not hiding file " + string);
        return false;
    }

    private static void initForSplashScreenUpdate() {
        if (null != m_splash) {
            m_g2d = m_splash.createGraphics();
            Dimension dimension = m_splash.getSize();
            m_splashWidth = (int)dimension.getWidth();
            m_splashHeight = (int)dimension.getHeight();
            m_textAreaXstart = 20;
            m_textAreaWidth = m_splashWidth - m_textAreaXstart;
            m_textAreaYstart = m_splashHeight - 50;
            m_textAreaYstartClear = m_splashHeight - 80;
            m_textAreaHeight = 40;
            m_progressBarXstart = 0;
            m_progressBarY = m_splashHeight - 20;
            m_progressBarChunks = 5;
            m_progressBarBumpSize = m_splashWidth / m_progressBarChunks;
        }
    }

    protected static void setSplashUpdatesForRewritingCache() {
        if (null != m_splash) {
            m_progressBarBumpSize = m_splashWidth / (m_progressBarChunks += 101);
        }
    }

    private static void updateSplashFrame(String string, String string2) {
        if (null != m_g2d && string != m_previousMajorText) {
            m_previousMajorText = string;
            try {
                SwingUtilities.invokeAndWait(() -> {
                    Composite composite = m_g2d.getComposite();
                    m_g2d.setComposite(AlphaComposite.Clear);
                    m_g2d.fillRect(m_textAreaXstart, m_textAreaYstartClear, m_textAreaWidth, m_textAreaHeight);
                    m_g2d.setPaintMode();
                    m_g2d.setColor(COLOR_DARK_BLUE);
                    m_g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    m_g2d.setFont(new Font("Arial", 0, 15));
                    m_g2d.drawString(string, m_textAreaXstart, m_textAreaYstart);
                    m_g2d.setComposite(composite);
                    AcsLaunchPad.updateProgressBar();
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AcsStartupUtil.addDelayedLog(exception);
            }
        }
    }

    protected static void updateProgressBar() {
        if (null != m_g2d) {
            int n = ++m_progressBarXUpdate >= m_progressBarChunks ? m_splashWidth : m_progressBarXUpdate * m_progressBarBumpSize;
            m_g2d.setColor(COLOR_DARK_BLUE);
            m_g2d.drawLine(m_progressBarXstart, m_progressBarY, n, m_progressBarY);
            m_g2d.drawLine(m_progressBarXstart, m_progressBarY + 1, n, m_progressBarY + 1);
            m_g2d.drawLine(m_progressBarXstart, m_progressBarY + 2, n, m_progressBarY + 2);
            m_splash.update();
        }
    }

    static {
        m_progressBarXUpdate = 0;
        m_splash = AcsLaunchPad.isGuiAvailable() ? SplashScreen.getSplashScreen() : null;
        m_g2d = null;
        m_previousMajorText = EMPTY_STR;
        m_pleaseWaitDialog = AcsLaunchPad.isGuiAvailable() ? new PleaseWait() : new PleaseWaitHeadless();
        initializedForTesting = false;
        CHECK_PROD_MSG = AcsStartupUtil.mri.nls("acsmsg.1");
        m_base_lib_dirs_forURI = new String[]{"lib/", "languages/"};
        m_plugin_dirs = new String[]{"database", "dataxfer", "emulator", "opconsole", "rmtcmd", "splf", "keyman", "ifs", "oss", "misc"};
        g_optimizeForPlugin = false;
        OPTIMIZED_INTERNAL_PLUGINS = new String[]{"com.ibm.iaccess.base.LmServer", "com.ibm.iaccess.cmdline.AcsDump", "com.ibm.iaccess.cmdline.AcsLog", "com.ibm.iaccess.cmdline.AcsLogon"};
        JARSWEKNOWDONTHAVEAMANIFEST = new String[]{"hodenablement_temp.jar", "jt400.jar", "jui400.jar", "tes.jar", "outputwriters.jar", "reportwriter.jar", "uitools.jar", "util400.jar", "dv.jar", "dvsa.jar", "dv_inav.jar", "ujsh.jar", "joinfinder.jar", "jopnav.jar", "jopnavfw.jar", "jcup.jar", "jhall.jar", "xml-apis.jar", "sqlmodel2.jar", "sqlmodel.jar", "sqlassist.jar", "sqlassist2.jar", "op.jar", "mofrt.jar", "jlpex13.jar", "helpbase.jar", "fw.jar", "Common.jar", "common.command.jar", "uil.jar", "runtime.jar", "ezcore.jar", "acsbasemri.jar", "acshod2.jar", "acshodmri.jar", "acssts.jar", "acsdataxferhelp.jar", "acsdataxferuno.jar", "acsdbaccess.jar", "acsopconhelp.jar", "acsopconmri2.jar", "acslicense.jar", "acslm.jar"};
        m_jarPrefixesMeaningNoManifest = new String[]{"cwbun", "ha", "hod", "aui", "cci", "ecore", "emf", "tsall", "dom4j-", "commons-", "xmlbeans-", "forms-", "looks-", "poi-", "odfdom-", "log4j-", "simple-odf", "acsbase", "jsch", "icu4j"};
        m_jarFilesHiddenFromView = new String[]{"dtuno.jar", "acsdtuno.jar", "dataxferuno.jar", "acsdataxferuno.jar"};
    }

    @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
    static class PleaseWaitHeadless
    implements AcsClassloaderStatusListener {
        PleaseWaitHeadless() {
        }

        @Override
        public void classloaderStatus(AcsClassLoaderStatusEvent acsClassLoaderStatusEvent) {
        }

        @Override
        public void productSeemsStarted() {
        }
    }

    @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
    static class PleaseWait
    extends JDialog
    implements AcsClassloaderStatusListener,
    WindowListener {
        private static final long serialVersionUID = -924127281755246776L;
        private final JLabel m_labelMajor = new JLabel();
        private final JLabel m_labelMinor = new JLabel();
        private volatile boolean m_isProductStarted = false;

        public PleaseWait() {
            this.setTitle(AcsStartupUtil.mri.nls("acsmsg.0"));
            this.setLayout(new GridLayout(2, 1));
            this.add(this.m_labelMajor);
            this.add(this.m_labelMinor);
            this.pack();
            this.setSize(900, 80);
            this.setMinimumSize(this.getSize());
            this.setMaximumSize(this.getSize());
            this.setLocationRelativeTo(null);
            this.setAlwaysOnTop(true);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(this);
        }

        @Override
        public void setVisible(boolean bl) {
            super.setVisible(AcsLaunchPad.isGuiAvailable() && bl);
        }

        @Override
        public void classloaderStatus(AcsClassLoaderStatusEvent acsClassLoaderStatusEvent) {
            AcsLaunchPad.updateSplashFrame(acsClassLoaderStatusEvent.getMajorText(), acsClassLoaderStatusEvent.getMinorText());
        }

        @Override
        public void productSeemsStarted() {
            this.m_isProductStarted = true;
            SwingUtilities.invokeLater(() -> {
                this.setVisible(false);
                this.dispose();
            });
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (!this.m_isProductStarted) {
                System.exit(-4);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

